define([
    'underscore',
    'marionette',
    'text!modules/new-appointment-request/views/common/error/template.html',
], function(_, Mn, template) {
    'use strict';


    /**
     * @class NewSchedulingErrorView
     * @typedef {Backbone.View<Backbone.Model>}
     */
    var ItemView = Mn.View.extend({
        template: _.template('<%- error %>'),
        tagName: 'li',
        serializeModel: function() {
            var data = this.model.toJSON();
            if (data.error) {
                return data;
            }
            if (this.isOptionDateFormattingNeeded(data)) {
                return this.optionDateParse(data);
            }

            if (data.errorMessage) {
                return {error: data.errorMessage};
            }

            return {error: 'An error has occurred'};
        },

        optionDateParse: function(error) {
            var number = _.last(error.fieldName);
            var prefix = 'Choice #' + number + ' Date: ';
            return {error: prefix + error.errorMessage};
        },

        isOptionDateFormattingNeeded: function(error) {
            var test;

            var fieldName = error.fieldName;
            if (fieldName) {
                test = fieldName.substr(0, fieldName.length - 1);
                return test === 'optionDate';
            }
            return false;
        },
    });


    return Mn.CompositeView.extend({
        template: _.template(template),
        childView: ItemView,
        childViewContainer: '.error-list',
        onRender: function() {
            this.$('#error-list-heading').focus();
        },
    });
});
